/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainConfigurationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateDomainConfigurationResponse> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainConfigurationResponse.getter(UpdateDomainConfigurationResponse::domainConfigurationName)).setter(UpdateDomainConfigurationResponse.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainConfigurationResponse.getter(UpdateDomainConfigurationResponse::domainConfigurationArn)).setter(UpdateDomainConfigurationResponse.setter(Builder::domainConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD));
    private final String domainConfigurationName;
    private final String domainConfigurationArn;

    private UpdateDomainConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
    }

    public String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public String domainConfigurationArn() {
        return this.domainConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigurationResponse)) {
            return false;
        }
        UpdateDomainConfigurationResponse other = (UpdateDomainConfigurationResponse)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainConfigurationArn(), other.domainConfigurationArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDomainConfigurationResponse").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainConfigurationArn", (Object)this.domainConfigurationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateDomainConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigurationResponse model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainConfigurationArn(model.domainConfigurationArn);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        public final String getDomainConfigurationArn() {
            return this.domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        @Override
        public UpdateDomainConfigurationResponse build() {
            return new UpdateDomainConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainConfigurationResponse> {
        public Builder domainConfigurationName(String var1);

        public Builder domainConfigurationArn(String var1);
    }
}

