/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalParameterMapCopier;
import software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.services.iot.model.OTAUpdateFilesCopier;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOtaUpdateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateOtaUpdateRequest> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::otaUpdateId)).setter(CreateOtaUpdateRequest.setter(Builder::otaUpdateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("otaUpdateId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::description)).setter(CreateOtaUpdateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::targets)).setter(CreateOtaUpdateRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::targetSelectionAsString)).setter(CreateOtaUpdateRequest.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()}).build();
    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::awsJobExecutionsRolloutConfig)).setter(CreateOtaUpdateRequest.setter(Builder::awsJobExecutionsRolloutConfig)).constructor(AwsJobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<List<OTAUpdateFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::files)).setter(CreateOtaUpdateRequest.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OTAUpdateFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::roleArn)).setter(CreateOtaUpdateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateOtaUpdateRequest.getter(CreateOtaUpdateRequest::additionalParameters)).setter(CreateOtaUpdateRequest.setter(Builder::additionalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, TARGET_SELECTION_FIELD, AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, FILES_FIELD, ROLE_ARN_FIELD, ADDITIONAL_PARAMETERS_FIELD));
    private final String otaUpdateId;
    private final String description;
    private final List<String> targets;
    private final String targetSelection;
    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
    private final List<OTAUpdateFile> files;
    private final String roleArn;
    private final Map<String, String> additionalParameters;

    private CreateOtaUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.description = builder.description;
        this.targets = builder.targets;
        this.targetSelection = builder.targetSelection;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
        this.additionalParameters = builder.additionalParameters;
    }

    public String otaUpdateId() {
        return this.otaUpdateId;
    }

    public String description() {
        return this.description;
    }

    public List<String> targets() {
        return this.targets;
    }

    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public String targetSelectionAsString() {
        return this.targetSelection;
    }

    public AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return this.awsJobExecutionsRolloutConfig;
    }

    public List<OTAUpdateFile> files() {
        return this.files;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Map<String, String> additionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.files());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateRequest)) {
            return false;
        }
        CreateOtaUpdateRequest other = (CreateOtaUpdateRequest)((Object)obj);
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig()) && Objects.equals(this.files(), other.files()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.additionalParameters(), other.additionalParameters());
    }

    public String toString() {
        return ToString.builder((String)"CreateOtaUpdateRequest").add("OtaUpdateId", (Object)this.otaUpdateId()).add("Description", (Object)this.description()).add("Targets", this.targets()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("AwsJobExecutionsRolloutConfig", (Object)this.awsJobExecutionsRolloutConfig()).add("Files", this.files()).add("RoleArn", (Object)this.roleArn()).add("AdditionalParameters", this.additionalParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "awsJobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobExecutionsRolloutConfig()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "additionalParameters": {
                return Optional.ofNullable(clazz.cast(this.additionalParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateRequest, T> g) {
        return obj -> g.apply((CreateOtaUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String description;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String targetSelection;
        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
        private List<OTAUpdateFile> files = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateRequest model) {
            super(model);
            this.otaUpdateId(model.otaUpdateId);
            this.description(model.description);
            this.targets(model.targets);
            this.targetSelection(model.targetSelection);
            this.awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            this.files(model.files);
            this.roleArn(model.roleArn);
            this.additionalParameters(model.additionalParameters);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return this.awsJobExecutionsRolloutConfig != null ? this.awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build() : null;
        }

        public final Collection<OTAUpdateFile.Builder> getFiles() {
            return this.files != null ? (Collection)this.files.stream().map(OTAUpdateFile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder files(Collection<OTAUpdateFile> files) {
            this.files = OTAUpdateFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(OTAUpdateFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<OTAUpdateFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (OTAUpdateFile)((OTAUpdateFile.Builder)OTAUpdateFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFiles(Collection<OTAUpdateFile.BuilderImpl> files) {
            this.files = OTAUpdateFilesCopier.copyFromBuilder(files);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getAdditionalParameters() {
            return this.additionalParameters;
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaUpdateRequest build() {
            return new CreateOtaUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOtaUpdateRequest> {
        public Builder otaUpdateId(String var1);

        public Builder description(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig var1);

        default public Builder awsJobExecutionsRolloutConfig(Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return this.awsJobExecutionsRolloutConfig((AwsJobExecutionsRolloutConfig)((AwsJobExecutionsRolloutConfig.Builder)AwsJobExecutionsRolloutConfig.builder().applyMutation(awsJobExecutionsRolloutConfig)).build());
        }

        public Builder files(Collection<OTAUpdateFile> var1);

        public Builder files(OTAUpdateFile ... var1);

        public Builder files(Consumer<OTAUpdateFile.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder additionalParameters(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

