/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.ViolationEvent;
import software.amazon.awssdk.services.iot.transform.BehaviorUnmarshaller;
import software.amazon.awssdk.services.iot.transform.MetricValueUnmarshaller;

public class ViolationEventUnmarshaller
implements Unmarshaller<ViolationEvent, JsonUnmarshallerContext> {
    private static final ViolationEventUnmarshaller INSTANCE = new ViolationEventUnmarshaller();

    public ViolationEvent unmarshall(JsonUnmarshallerContext context) throws Exception {
        ViolationEvent.Builder violationEventBuilder = ViolationEvent.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("violationId", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.violationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingName", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.thingName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("securityProfileName", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.securityProfileName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("behavior", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.behavior(BehaviorUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("metricValue", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.metricValue(MetricValueUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("violationEventType", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.violationEventType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("violationEventTime", targetDepth)) {
                    context.nextToken();
                    violationEventBuilder.violationEventTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ViolationEvent)violationEventBuilder.build();
    }

    public static ViolationEventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

