/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateScheduledAuditRequestModelMarshaller {
    private static final MarshallingInfo<String> FREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").isBinary(false).build();
    private static final MarshallingInfo<String> DAYOFMONTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfMonth").isBinary(false).build();
    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfWeek").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETCHECKNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetCheckNames").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEDULEDAUDITNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("scheduledAuditName").isBinary(false).build();
    private static final UpdateScheduledAuditRequestModelMarshaller INSTANCE = new UpdateScheduledAuditRequestModelMarshaller();

    private UpdateScheduledAuditRequestModelMarshaller() {
    }

    public static UpdateScheduledAuditRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateScheduledAuditRequest updateScheduledAuditRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateScheduledAuditRequest), (String)"updateScheduledAuditRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateScheduledAuditRequest.frequencyAsString(), FREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)updateScheduledAuditRequest.dayOfMonth(), DAYOFMONTH_BINDING);
            protocolMarshaller.marshall((Object)updateScheduledAuditRequest.dayOfWeekAsString(), DAYOFWEEK_BINDING);
            protocolMarshaller.marshall(updateScheduledAuditRequest.targetCheckNames(), TARGETCHECKNAMES_BINDING);
            protocolMarshaller.marshall((Object)updateScheduledAuditRequest.scheduledAuditName(), SCHEDULEDAUDITNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

