/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TransferData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransferDataMarshaller {
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").isBinary(false).build();
    private static final MarshallingInfo<String> REJECTREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectReason").isBinary(false).build();
    private static final MarshallingInfo<Instant> TRANSFERDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> ACCEPTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> REJECTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectDate").isBinary(false).build();
    private static final TransferDataMarshaller INSTANCE = new TransferDataMarshaller();

    private TransferDataMarshaller() {
    }

    public static TransferDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransferData transferData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transferData, (String)"transferData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transferData.transferMessage(), TRANSFERMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)transferData.rejectReason(), REJECTREASON_BINDING);
            protocolMarshaller.marshall((Object)transferData.transferDate(), TRANSFERDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.acceptDate(), ACCEPTDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.rejectDate(), REJECTDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

