/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.TopicRulePayload;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TopicRulePayloadMarshaller {
    private static final MarshallingInfo<String> SQL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sql").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RULEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleDisabled").isBinary(false).build();
    private static final MarshallingInfo<String> AWSIOTSQLVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotSqlVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorAction").isBinary(false).build();
    private static final TopicRulePayloadMarshaller INSTANCE = new TopicRulePayloadMarshaller();

    private TopicRulePayloadMarshaller() {
    }

    public static TopicRulePayloadMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicRulePayload topicRulePayload, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)topicRulePayload, (String)"topicRulePayload");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)topicRulePayload.sql(), SQL_BINDING);
            protocolMarshaller.marshall((Object)topicRulePayload.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(topicRulePayload.actions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)topicRulePayload.ruleDisabled(), RULEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)topicRulePayload.awsIotSqlVersion(), AWSIOTSQLVERSION_BINDING);
            protocolMarshaller.marshall((Object)topicRulePayload.errorAction(), ERRORACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

