/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingGroupMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingGroupMetadataMarshaller {
    private static final MarshallingInfo<String> PARENTGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentGroupName").isBinary(false).build();
    private static final MarshallingInfo<List> ROOTTOPARENTTHINGGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rootToParentThingGroups").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final ThingGroupMetadataMarshaller INSTANCE = new ThingGroupMetadataMarshaller();

    private ThingGroupMetadataMarshaller() {
    }

    public static ThingGroupMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingGroupMetadata thingGroupMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingGroupMetadata, (String)"thingGroupMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingGroupMetadata.parentGroupName(), PARENTGROUPNAME_BINDING);
            protocolMarshaller.marshall(thingGroupMetadata.rootToParentThingGroups(), ROOTTOPARENTTHINGGROUPS_BINDING);
            protocolMarshaller.marshall((Object)thingGroupMetadata.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

