/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.ThingDocument;

public class ThingDocumentUnmarshaller
implements Unmarshaller<ThingDocument, JsonUnmarshallerContext> {
    private static final ThingDocumentUnmarshaller INSTANCE = new ThingDocumentUnmarshaller();

    public ThingDocument unmarshall(JsonUnmarshallerContext context) throws Exception {
        ThingDocument.Builder thingDocumentBuilder = ThingDocument.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("thingName", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.thingName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingId", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.thingId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingTypeName", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.thingTypeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingGroupNames", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.thingGroupNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("attributes", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("shadow", targetDepth)) {
                    context.nextToken();
                    thingDocumentBuilder.shadow((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ThingDocument)thingDocumentBuilder.build();
    }

    public static ThingDocumentUnmarshaller getInstance() {
        return INSTANCE;
    }
}

