/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.TaskStatistics;

public class TaskStatisticsUnmarshaller
implements Unmarshaller<TaskStatistics, JsonUnmarshallerContext> {
    private static final TaskStatisticsUnmarshaller INSTANCE = new TaskStatisticsUnmarshaller();

    public TaskStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        TaskStatistics.Builder taskStatisticsBuilder = TaskStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("totalChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.totalChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("inProgressChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.inProgressChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("waitingForDataCollectionChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.waitingForDataCollectionChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("compliantChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.compliantChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("nonCompliantChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.nonCompliantChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("failedChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.failedChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("canceledChecks", targetDepth)) {
                    context.nextToken();
                    taskStatisticsBuilder.canceledChecks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TaskStatistics)taskStatisticsBuilder.build();
    }

    public static TaskStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

