/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.StreamInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamInfoMarshaller {
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamId").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> STREAMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> FILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("files").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final StreamInfoMarshaller INSTANCE = new StreamInfoMarshaller();

    private StreamInfoMarshaller() {
    }

    public static StreamInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamInfo streamInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamInfo, (String)"streamInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamInfo.streamId(), STREAMID_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.streamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.streamVersion(), STREAMVERSION_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(streamInfo.files(), FILES_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)streamInfo.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

