/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.StreamFile;
import software.amazon.awssdk.services.iot.transform.S3LocationUnmarshaller;

public class StreamFileUnmarshaller
implements Unmarshaller<StreamFile, JsonUnmarshallerContext> {
    private static final StreamFileUnmarshaller INSTANCE = new StreamFileUnmarshaller();

    public StreamFile unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamFile.Builder streamFileBuilder = StreamFile.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("fileId", targetDepth)) {
                    context.nextToken();
                    streamFileBuilder.fileId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3Location", targetDepth)) {
                    context.nextToken();
                    streamFileBuilder.s3Location(S3LocationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamFile)streamFileBuilder.build();
    }

    public static StreamFileUnmarshaller getInstance() {
        return INSTANCE;
    }
}

