/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.StreamFile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamFileMarshaller {
    private static final MarshallingInfo<Integer> FILEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").isBinary(false).build();
    private static final StreamFileMarshaller INSTANCE = new StreamFileMarshaller();

    private StreamFileMarshaller() {
    }

    public static StreamFileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamFile streamFile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamFile, (String)"streamFile");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamFile.fileId(), FILEID_BINDING);
            protocolMarshaller.marshall((Object)streamFile.s3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

