/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.StepFunctionsAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepFunctionsActionMarshaller {
    private static final MarshallingInfo<String> EXECUTIONNAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionNamePrefix").isBinary(false).build();
    private static final MarshallingInfo<String> STATEMACHINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateMachineName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final StepFunctionsActionMarshaller INSTANCE = new StepFunctionsActionMarshaller();

    private StepFunctionsActionMarshaller() {
    }

    public static StepFunctionsActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepFunctionsAction stepFunctionsAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepFunctionsAction, (String)"stepFunctionsAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepFunctionsAction.executionNamePrefix(), EXECUTIONNAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)stepFunctionsAction.stateMachineName(), STATEMACHINENAME_BINDING);
            protocolMarshaller.marshall((Object)stepFunctionsAction.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

