/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SigningProfileParameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SigningProfileParameterMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPATHONDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePathOnDevice").isBinary(false).build();
    private static final SigningProfileParameterMarshaller INSTANCE = new SigningProfileParameterMarshaller();

    private SigningProfileParameterMarshaller() {
    }

    public static SigningProfileParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SigningProfileParameter signingProfileParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)signingProfileParameter, (String)"signingProfileParameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)signingProfileParameter.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)signingProfileParameter.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)signingProfileParameter.certificatePathOnDevice(), CERTIFICATEPATHONDEVICE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

