/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecurityProfileTargetMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final SecurityProfileTargetMarshaller INSTANCE = new SecurityProfileTargetMarshaller();

    private SecurityProfileTargetMarshaller() {
    }

    public static SecurityProfileTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityProfileTarget securityProfileTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)securityProfileTarget, (String)"securityProfileTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)securityProfileTarget.arn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

