/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OTAUpdateFileMarshaller {
    private static final MarshallingInfo<String> FILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileName").isBinary(false).build();
    private static final MarshallingInfo<String> FILEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FILELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileLocation").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CODESIGNING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codeSigning").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();
    private static final OTAUpdateFileMarshaller INSTANCE = new OTAUpdateFileMarshaller();

    private OTAUpdateFileMarshaller() {
    }

    public static OTAUpdateFileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OTAUpdateFile otaUpdateFile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)otaUpdateFile, (String)"otaUpdateFile");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)otaUpdateFile.fileName(), FILENAME_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateFile.fileVersion(), FILEVERSION_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateFile.fileLocation(), FILELOCATION_BINDING);
            protocolMarshaller.marshall((Object)otaUpdateFile.codeSigning(), CODESIGNING_BINDING);
            protocolMarshaller.marshall(otaUpdateFile.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

