/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.Job;
import software.amazon.awssdk.services.iot.transform.JobExecutionsRolloutConfigUnmarshaller;
import software.amazon.awssdk.services.iot.transform.JobProcessDetailsUnmarshaller;
import software.amazon.awssdk.services.iot.transform.PresignedUrlConfigUnmarshaller;

public class JobUnmarshaller
implements Unmarshaller<Job, JsonUnmarshallerContext> {
    private static final JobUnmarshaller INSTANCE = new JobUnmarshaller();

    public Job unmarshall(JsonUnmarshallerContext context) throws Exception {
        Job.Builder jobBuilder = Job.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("jobArn", targetDepth)) {
                    context.nextToken();
                    jobBuilder.jobArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("jobId", targetDepth)) {
                    context.nextToken();
                    jobBuilder.jobId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("targetSelection", targetDepth)) {
                    context.nextToken();
                    jobBuilder.targetSelection((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    jobBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("forceCanceled", targetDepth)) {
                    context.nextToken();
                    jobBuilder.forceCanceled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("comment", targetDepth)) {
                    context.nextToken();
                    jobBuilder.comment((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("targets", targetDepth)) {
                    context.nextToken();
                    jobBuilder.targets(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    jobBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("presignedUrlConfig", targetDepth)) {
                    context.nextToken();
                    jobBuilder.presignedUrlConfig(PresignedUrlConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("jobExecutionsRolloutConfig", targetDepth)) {
                    context.nextToken();
                    jobBuilder.jobExecutionsRolloutConfig(JobExecutionsRolloutConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    jobBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("lastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    jobBuilder.lastUpdatedAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("completedAt", targetDepth)) {
                    context.nextToken();
                    jobBuilder.completedAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("jobProcessDetails", targetDepth)) {
                    context.nextToken();
                    jobBuilder.jobProcessDetails(JobProcessDetailsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Job)jobBuilder.build();
    }

    public static JobUnmarshaller getInstance() {
        return INSTANCE;
    }
}

