/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.JobSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobSummaryMarshaller {
    private static final MarshallingInfo<String> JOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobArn").isBinary(false).build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetSelection").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedAt").isBinary(false).build();
    private static final JobSummaryMarshaller INSTANCE = new JobSummaryMarshaller();

    private JobSummaryMarshaller() {
    }

    public static JobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobSummary jobSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobSummary, (String)"jobSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobSummary.jobArn(), JOBARN_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.thingGroupId(), THINGGROUPID_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.targetSelectionAsString(), TARGETSELECTION_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.completedAt(), COMPLETEDAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

