/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.JobExecutionSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobExecutionSummaryMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> QUEUEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queuedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<Long> EXECUTIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionNumber").isBinary(false).build();
    private static final JobExecutionSummaryMarshaller INSTANCE = new JobExecutionSummaryMarshaller();

    private JobExecutionSummaryMarshaller() {
    }

    public static JobExecutionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobExecutionSummary jobExecutionSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobExecutionSummary, (String)"jobExecutionSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobExecutionSummary.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobExecutionSummary.queuedAt(), QUEUEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecutionSummary.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecutionSummary.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobExecutionSummary.executionNumber(), EXECUTIONNUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

