/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.IotAnalyticsAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IotAnalyticsActionMarshaller {
    private static final MarshallingInfo<String> CHANNELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelArn").isBinary(false).build();
    private static final MarshallingInfo<String> CHANNELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final IotAnalyticsActionMarshaller INSTANCE = new IotAnalyticsActionMarshaller();

    private IotAnalyticsActionMarshaller() {
    }

    public static IotAnalyticsActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IotAnalyticsAction iotAnalyticsAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)iotAnalyticsAction, (String)"iotAnalyticsAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)iotAnalyticsAction.channelArn(), CHANNELARN_BINDING);
            protocolMarshaller.marshall((Object)iotAnalyticsAction.channelName(), CHANNELNAME_BINDING);
            protocolMarshaller.marshall((Object)iotAnalyticsAction.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

