/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.FileLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FileLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> STREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stream").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").isBinary(false).build();
    private static final FileLocationMarshaller INSTANCE = new FileLocationMarshaller();

    private FileLocationMarshaller() {
    }

    public static FileLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FileLocation fileLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fileLocation, (String)"fileLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fileLocation.stream(), STREAM_BINDING);
            protocolMarshaller.marshall((Object)fileLocation.s3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

