/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ExplicitDeny;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExplicitDenyMarshaller {
    private static final MarshallingInfo<List> POLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policies").isBinary(false).build();
    private static final ExplicitDenyMarshaller INSTANCE = new ExplicitDenyMarshaller();

    private ExplicitDenyMarshaller() {
    }

    public static ExplicitDenyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExplicitDeny explicitDeny, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)explicitDeny, (String)"explicitDeny");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(explicitDeny.policies(), POLICIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

