/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Destination;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DestinationMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Destination").isBinary(false).build();
    private static final DestinationMarshaller INSTANCE = new DestinationMarshaller();

    private DestinationMarshaller() {
    }

    public static DestinationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Destination destination, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)destination, (String)"destination");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)destination.s3Destination(), S3DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

