/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("streamId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> FILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("files").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final CreateStreamRequestModelMarshaller INSTANCE = new CreateStreamRequestModelMarshaller();

    private CreateStreamRequestModelMarshaller() {
    }

    public static CreateStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStreamRequest createStreamRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStreamRequest), (String)"createStreamRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStreamRequest.streamId(), STREAMID_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createStreamRequest.files(), FILES_BINDING);
            protocolMarshaller.marshall((Object)createStreamRequest.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

