/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.Configuration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final ConfigurationMarshaller INSTANCE = new ConfigurationMarshaller();

    private ConfigurationMarshaller() {
    }

    public static ConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Configuration configuration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configuration, (String)"configuration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configuration.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

