/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CancelJobExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FORCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("force").isBinary(false).build();
    private static final MarshallingInfo<Long> EXPECTEDVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expectedVersion").isBinary(false).build();
    private static final MarshallingInfo<Map> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusDetails").isBinary(false).build();
    private static final CancelJobExecutionRequestModelMarshaller INSTANCE = new CancelJobExecutionRequestModelMarshaller();

    private CancelJobExecutionRequestModelMarshaller() {
    }

    public static CancelJobExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CancelJobExecutionRequest cancelJobExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)cancelJobExecutionRequest), (String)"cancelJobExecutionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cancelJobExecutionRequest.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)cancelJobExecutionRequest.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)cancelJobExecutionRequest.force(), FORCE_BINDING);
            protocolMarshaller.marshall((Object)cancelJobExecutionRequest.expectedVersion(), EXPECTEDVERSION_BINDING);
            protocolMarshaller.marshall(cancelJobExecutionRequest.statusDetails(), STATUSDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

