/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuditCheckDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuditCheckDetailsMarshaller {
    private static final MarshallingInfo<String> CHECKRUNSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkRunStatus").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CHECKCOMPLIANT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkCompliant").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALRESOURCESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalResourcesCount").isBinary(false).build();
    private static final MarshallingInfo<Long> NONCOMPLIANTRESOURCESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantResourcesCount").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final AuditCheckDetailsMarshaller INSTANCE = new AuditCheckDetailsMarshaller();

    private AuditCheckDetailsMarshaller() {
    }

    public static AuditCheckDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuditCheckDetails auditCheckDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)auditCheckDetails, (String)"auditCheckDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)auditCheckDetails.checkRunStatusAsString(), CHECKRUNSTATUS_BINDING);
            protocolMarshaller.marshall((Object)auditCheckDetails.checkCompliant(), CHECKCOMPLIANT_BINDING);
            protocolMarshaller.marshall((Object)auditCheckDetails.totalResourcesCount(), TOTALRESOURCESCOUNT_BINDING);
            protocolMarshaller.marshall((Object)auditCheckDetails.nonCompliantResourcesCount(), NONCOMPLIANTRESOURCESCOUNT_BINDING);
            protocolMarshaller.marshall((Object)auditCheckDetails.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)auditCheckDetails.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

