/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuditCheckConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuditCheckConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").isBinary(false).build();
    private static final AuditCheckConfigurationMarshaller INSTANCE = new AuditCheckConfigurationMarshaller();

    private AuditCheckConfigurationMarshaller() {
    }

    public static AuditCheckConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuditCheckConfiguration auditCheckConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)auditCheckConfiguration, (String)"auditCheckConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)auditCheckConfiguration.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

