/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ActiveViolation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActiveViolationMarshaller {
    private static final MarshallingInfo<String> VIOLATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behavior").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LASTVIOLATIONVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastViolationValue").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTVIOLATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastViolationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> VIOLATIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationStartTime").isBinary(false).build();
    private static final ActiveViolationMarshaller INSTANCE = new ActiveViolationMarshaller();

    private ActiveViolationMarshaller() {
    }

    public static ActiveViolationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActiveViolation activeViolation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activeViolation, (String)"activeViolation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activeViolation.violationId(), VIOLATIONID_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.behavior(), BEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.lastViolationValue(), LASTVIOLATIONVALUE_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.lastViolationTime(), LASTVIOLATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)activeViolation.violationStartTime(), VIOLATIONSTARTTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

