/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ValidationError;
import software.amazon.awssdk.services.iot.model.ValidationErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateSecurityProfileBehaviorsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ValidateSecurityProfileBehaviorsResponse> {
    private final Boolean valid;
    private final List<ValidationError> validationErrors;

    private ValidateSecurityProfileBehaviorsResponse(BuilderImpl builder) {
        super(builder);
        this.valid = builder.valid;
        this.validationErrors = builder.validationErrors;
    }

    public Boolean valid() {
        return this.valid;
    }

    public List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valid());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSecurityProfileBehaviorsResponse)) {
            return false;
        }
        ValidateSecurityProfileBehaviorsResponse other = (ValidateSecurityProfileBehaviorsResponse)((Object)obj);
        return Objects.equals(this.valid(), other.valid()) && Objects.equals(this.validationErrors(), other.validationErrors());
    }

    public String toString() {
        return ToString.builder((String)"ValidateSecurityProfileBehaviorsResponse").add("Valid", (Object)this.valid()).add("ValidationErrors", this.validationErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "valid": {
                return Optional.ofNullable(clazz.cast(this.valid()));
            }
            case "validationErrors": {
                return Optional.ofNullable(clazz.cast(this.validationErrors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private Boolean valid;
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSecurityProfileBehaviorsResponse model) {
            super(model);
            this.valid(model.valid);
            this.validationErrors(model.validationErrors);
        }

        public final Boolean getValid() {
            return this.valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return this.validationErrors != null ? (Collection)this.validationErrors.stream().map(ValidationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder> ... validationErrors) {
            this.validationErrors(Stream.of(validationErrors).map(c -> (ValidationError)((ValidationError.Builder)ValidationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public ValidateSecurityProfileBehaviorsResponse build() {
            return new ValidateSecurityProfileBehaviorsResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ValidateSecurityProfileBehaviorsResponse> {
        public Builder valid(Boolean var1);

        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder validationErrors(Consumer<ValidationError.Builder> ... var1);
    }
}

