/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateSecurityProfileBehaviorsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ValidateSecurityProfileBehaviorsRequest> {
    private final List<Behavior> behaviors;

    private ValidateSecurityProfileBehaviorsRequest(BuilderImpl builder) {
        super(builder);
        this.behaviors = builder.behaviors;
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSecurityProfileBehaviorsRequest)) {
            return false;
        }
        ValidateSecurityProfileBehaviorsRequest other = (ValidateSecurityProfileBehaviorsRequest)((Object)obj);
        return Objects.equals(this.behaviors(), other.behaviors());
    }

    public String toString() {
        return ToString.builder((String)"ValidateSecurityProfileBehaviorsRequest").add("Behaviors", this.behaviors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSecurityProfileBehaviorsRequest model) {
            super(model);
            this.behaviors(model.behaviors);
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateSecurityProfileBehaviorsRequest build() {
            return new ValidateSecurityProfileBehaviorsRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, ValidateSecurityProfileBehaviorsRequest> {
        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

