/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThingGroupsForThingRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
    private final String thingName;
    private final List<String> thingGroupsToAdd;
    private final List<String> thingGroupsToRemove;

    private UpdateThingGroupsForThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingGroupsToAdd = builder.thingGroupsToAdd;
        this.thingGroupsToRemove = builder.thingGroupsToRemove;
    }

    public String thingName() {
        return this.thingName;
    }

    public List<String> thingGroupsToAdd() {
        return this.thingGroupsToAdd;
    }

    public List<String> thingGroupsToRemove() {
        return this.thingGroupsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupsToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingGroupsForThingRequest)) {
            return false;
        }
        UpdateThingGroupsForThingRequest other = (UpdateThingGroupsForThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingGroupsToAdd(), other.thingGroupsToAdd()) && Objects.equals(this.thingGroupsToRemove(), other.thingGroupsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UpdateThingGroupsForThingRequest").add("ThingName", (Object)this.thingName()).add("ThingGroupsToAdd", this.thingGroupsToAdd()).add("ThingGroupsToRemove", this.thingGroupsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingGroupsToAdd": {
                return Optional.ofNullable(clazz.cast(this.thingGroupsToAdd()));
            }
            case "thingGroupsToRemove": {
                return Optional.ofNullable(clazz.cast(this.thingGroupsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private List<String> thingGroupsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> thingGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingGroupsForThingRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.thingGroupsToAdd(model.thingGroupsToAdd);
            this.thingGroupsToRemove(model.thingGroupsToRemove);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Collection<String> getThingGroupsToAdd() {
            return this.thingGroupsToAdd;
        }

        @Override
        public final Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToAdd(String ... thingGroupsToAdd) {
            this.thingGroupsToAdd(Arrays.asList(thingGroupsToAdd));
            return this;
        }

        public final void setThingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
        }

        public final Collection<String> getThingGroupsToRemove() {
            return this.thingGroupsToRemove;
        }

        @Override
        public final Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToRemove(String ... thingGroupsToRemove) {
            this.thingGroupsToRemove(Arrays.asList(thingGroupsToRemove));
            return this;
        }

        public final void setThingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingGroupsForThingRequest build() {
            return new UpdateThingGroupsForThingRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
        public Builder thingName(String var1);

        public Builder thingGroupsToAdd(Collection<String> var1);

        public Builder thingGroupsToAdd(String ... var1);

        public Builder thingGroupsToRemove(Collection<String> var1);

        public Builder thingGroupsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

