/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.StreamFile;
import software.amazon.awssdk.services.iot.model.StreamFilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateStreamRequest> {
    private final String streamId;
    private final String description;
    private final List<StreamFile> files;
    private final String roleArn;

    private UpdateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamId = builder.streamId;
        this.description = builder.description;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
    }

    public String streamId() {
        return this.streamId;
    }

    public String description() {
        return this.description;
    }

    public List<StreamFile> files() {
        return this.files;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.files());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamRequest)) {
            return false;
        }
        UpdateStreamRequest other = (UpdateStreamRequest)((Object)obj);
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.files(), other.files()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateStreamRequest").add("StreamId", (Object)this.streamId()).add("Description", (Object)this.description()).add("Files", this.files()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String streamId;
        private String description;
        private List<StreamFile> files = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamRequest model) {
            super(model);
            this.streamId(model.streamId);
            this.description(model.description);
            this.files(model.files);
            this.roleArn(model.roleArn);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<StreamFile.Builder> getFiles() {
            return this.files != null ? (Collection)this.files.stream().map(StreamFile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder files(Collection<StreamFile> files) {
            this.files = StreamFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(StreamFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<StreamFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (StreamFile)((StreamFile.Builder)StreamFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFiles(Collection<StreamFile.BuilderImpl> files) {
            this.files = StreamFilesCopier.copyFromBuilder(files);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamRequest build() {
            return new UpdateStreamRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateStreamRequest> {
        public Builder streamId(String var1);

        public Builder description(String var1);

        public Builder files(Collection<StreamFile> var1);

        public Builder files(StreamFile ... var1);

        public Builder files(Consumer<StreamFile.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

