/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityProfileRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateSecurityProfileRequest> {
    private final String securityProfileName;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;
    private final Long expectedVersion;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.expectedVersion = builder.expectedVersion;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return TypeConverter.convert(this.alertTargets, AlertTargetType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)AlertTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && Objects.equals(this.behaviors(), other.behaviors()) && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings()) && Objects.equals(this.expectedVersion(), other.expectedVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.behaviors()).add("AlertTargets", this.alertTargetsAsStrings()).add("ExpectedVersion", (Object)this.expectedVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();
        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
            this.expectedVersion(model.expectedVersion);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder expectedVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

