/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration;
import software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIndexingConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateIndexingConfigurationRequest> {
    private final ThingIndexingConfiguration thingIndexingConfiguration;
    private final ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

    private UpdateIndexingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.thingIndexingConfiguration = builder.thingIndexingConfiguration;
        this.thingGroupIndexingConfiguration = builder.thingGroupIndexingConfiguration;
    }

    public ThingIndexingConfiguration thingIndexingConfiguration() {
        return this.thingIndexingConfiguration;
    }

    public ThingGroupIndexingConfiguration thingGroupIndexingConfiguration() {
        return this.thingGroupIndexingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingIndexingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupIndexingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexingConfigurationRequest)) {
            return false;
        }
        UpdateIndexingConfigurationRequest other = (UpdateIndexingConfigurationRequest)((Object)obj);
        return Objects.equals(this.thingIndexingConfiguration(), other.thingIndexingConfiguration()) && Objects.equals(this.thingGroupIndexingConfiguration(), other.thingGroupIndexingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateIndexingConfigurationRequest").add("ThingIndexingConfiguration", (Object)this.thingIndexingConfiguration()).add("ThingGroupIndexingConfiguration", (Object)this.thingGroupIndexingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingIndexingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thingIndexingConfiguration()));
            }
            case "thingGroupIndexingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thingGroupIndexingConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private ThingIndexingConfiguration thingIndexingConfiguration;
        private ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexingConfigurationRequest model) {
            super(model);
            this.thingIndexingConfiguration(model.thingIndexingConfiguration);
            this.thingGroupIndexingConfiguration(model.thingGroupIndexingConfiguration);
        }

        public final ThingIndexingConfiguration.Builder getThingIndexingConfiguration() {
            return this.thingIndexingConfiguration != null ? this.thingIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration;
            return this;
        }

        public final void setThingIndexingConfiguration(ThingIndexingConfiguration.BuilderImpl thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration != null ? thingIndexingConfiguration.build() : null;
        }

        public final ThingGroupIndexingConfiguration.Builder getThingGroupIndexingConfiguration() {
            return this.thingGroupIndexingConfiguration != null ? this.thingGroupIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration;
            return this;
        }

        public final void setThingGroupIndexingConfiguration(ThingGroupIndexingConfiguration.BuilderImpl thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexingConfigurationRequest build() {
            return new UpdateIndexingConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateIndexingConfigurationRequest> {
        public Builder thingIndexingConfiguration(ThingIndexingConfiguration var1);

        default public Builder thingIndexingConfiguration(Consumer<ThingIndexingConfiguration.Builder> thingIndexingConfiguration) {
            return this.thingIndexingConfiguration((ThingIndexingConfiguration)((ThingIndexingConfiguration.Builder)ThingIndexingConfiguration.builder().applyMutation(thingIndexingConfiguration)).build());
        }

        public Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration var1);

        default public Builder thingGroupIndexingConfiguration(Consumer<ThingGroupIndexingConfiguration.Builder> thingGroupIndexingConfiguration) {
            return this.thingGroupIndexingConfiguration((ThingGroupIndexingConfiguration)((ThingGroupIndexingConfiguration.Builder)ThingGroupIndexingConfiguration.builder().applyMutation(thingGroupIndexingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

