/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.services.iot.transform.ThingGroupPropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingGroupProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingGroupProperties> {
    private final String thingGroupDescription;
    private final AttributePayload attributePayload;

    private ThingGroupProperties(BuilderImpl builder) {
        this.thingGroupDescription = builder.thingGroupDescription;
        this.attributePayload = builder.attributePayload;
    }

    public String thingGroupDescription() {
        return this.thingGroupDescription;
    }

    public AttributePayload attributePayload() {
        return this.attributePayload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePayload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupProperties)) {
            return false;
        }
        ThingGroupProperties other = (ThingGroupProperties)obj;
        return Objects.equals(this.thingGroupDescription(), other.thingGroupDescription()) && Objects.equals(this.attributePayload(), other.attributePayload());
    }

    public String toString() {
        return ToString.builder((String)"ThingGroupProperties").add("ThingGroupDescription", (Object)this.thingGroupDescription()).add("AttributePayload", (Object)this.attributePayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.thingGroupDescription()));
            }
            case "attributePayload": {
                return Optional.ofNullable(clazz.cast(this.attributePayload()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingGroupDescription;
        private AttributePayload attributePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupProperties model) {
            this.thingGroupDescription(model.thingGroupDescription);
            this.attributePayload(model.attributePayload);
        }

        public final String getThingGroupDescription() {
            return this.thingGroupDescription;
        }

        @Override
        public final Builder thingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
            return this;
        }

        public final void setThingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return this.attributePayload != null ? this.attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public ThingGroupProperties build() {
            return new ThingGroupProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingGroupProperties> {
        public Builder thingGroupDescription(String var1);

        public Builder attributePayload(AttributePayload var1);

        default public Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return this.attributePayload((AttributePayload)((AttributePayload.Builder)AttributePayload.builder().applyMutation(attributePayload)).build());
        }
    }
}

