/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ThingGroupNameAndArnListCopier;
import software.amazon.awssdk.services.iot.transform.ThingGroupMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingGroupMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingGroupMetadata> {
    private final String parentGroupName;
    private final List<GroupNameAndArn> rootToParentThingGroups;
    private final Instant creationDate;

    private ThingGroupMetadata(BuilderImpl builder) {
        this.parentGroupName = builder.parentGroupName;
        this.rootToParentThingGroups = builder.rootToParentThingGroups;
        this.creationDate = builder.creationDate;
    }

    public String parentGroupName() {
        return this.parentGroupName;
    }

    public List<GroupNameAndArn> rootToParentThingGroups() {
        return this.rootToParentThingGroups;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootToParentThingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupMetadata)) {
            return false;
        }
        ThingGroupMetadata other = (ThingGroupMetadata)obj;
        return Objects.equals(this.parentGroupName(), other.parentGroupName()) && Objects.equals(this.rootToParentThingGroups(), other.rootToParentThingGroups()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"ThingGroupMetadata").add("ParentGroupName", (Object)this.parentGroupName()).add("RootToParentThingGroups", this.rootToParentThingGroups()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parentGroupName": {
                return Optional.ofNullable(clazz.cast(this.parentGroupName()));
            }
            case "rootToParentThingGroups": {
                return Optional.ofNullable(clazz.cast(this.rootToParentThingGroups()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String parentGroupName;
        private List<GroupNameAndArn> rootToParentThingGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupMetadata model) {
            this.parentGroupName(model.parentGroupName);
            this.rootToParentThingGroups(model.rootToParentThingGroups);
            this.creationDate(model.creationDate);
        }

        public final String getParentGroupName() {
            return this.parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        public final Collection<GroupNameAndArn.Builder> getRootToParentThingGroups() {
            return this.rootToParentThingGroups != null ? (Collection)this.rootToParentThingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copy(rootToParentThingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(GroupNameAndArn ... rootToParentThingGroups) {
            this.rootToParentThingGroups(Arrays.asList(rootToParentThingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder> ... rootToParentThingGroups) {
            this.rootToParentThingGroups(Stream.of(rootToParentThingGroups).map(c -> (GroupNameAndArn)((GroupNameAndArn.Builder)GroupNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRootToParentThingGroups(Collection<GroupNameAndArn.BuilderImpl> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(rootToParentThingGroups);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public ThingGroupMetadata build() {
            return new ThingGroupMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingGroupMetadata> {
        public Builder parentGroupName(String var1);

        public Builder rootToParentThingGroups(Collection<GroupNameAndArn> var1);

        public Builder rootToParentThingGroups(GroupNameAndArn ... var1);

        public Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder> ... var1);

        public Builder creationDate(Instant var1);
    }
}

