/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.model.ThingGroupNameListCopier;
import software.amazon.awssdk.services.iot.transform.ThingDocumentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingDocument
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingDocument> {
    private final String thingName;
    private final String thingId;
    private final String thingTypeName;
    private final List<String> thingGroupNames;
    private final Map<String, String> attributes;
    private final String shadow;

    private ThingDocument(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingTypeName = builder.thingTypeName;
        this.thingGroupNames = builder.thingGroupNames;
        this.attributes = builder.attributes;
        this.shadow = builder.shadow;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingId() {
        return this.thingId;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public List<String> thingGroupNames() {
        return this.thingGroupNames;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String shadow() {
        return this.shadow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadow());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument)obj;
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingId(), other.thingId()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.thingGroupNames(), other.thingGroupNames()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.shadow(), other.shadow());
    }

    public String toString() {
        return ToString.builder((String)"ThingDocument").add("ThingName", (Object)this.thingName()).add("ThingId", (Object)this.thingId()).add("ThingTypeName", (Object)this.thingTypeName()).add("ThingGroupNames", this.thingGroupNames()).add("Attributes", this.attributes()).add("Shadow", (Object)this.shadow()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingId": {
                return Optional.ofNullable(clazz.cast(this.thingId()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "thingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.thingGroupNames()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "shadow": {
                return Optional.ofNullable(clazz.cast(this.shadow()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private String thingId;
        private String thingTypeName;
        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String shadow;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingDocument model) {
            this.thingName(model.thingName);
            this.thingId(model.thingId);
            this.thingTypeName(model.thingTypeName);
            this.thingGroupNames(model.thingGroupNames);
            this.attributes(model.attributes);
            this.shadow(model.shadow);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingId() {
            return this.thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Collection<String> getThingGroupNames() {
            return this.thingGroupNames;
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String ... thingGroupNames) {
            this.thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final String getShadow() {
            return this.shadow;
        }

        @Override
        public final Builder shadow(String shadow) {
            this.shadow = shadow;
            return this;
        }

        public final void setShadow(String shadow) {
            this.shadow = shadow;
        }

        public ThingDocument build() {
            return new ThingDocument(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingDocument> {
        public Builder thingName(String var1);

        public Builder thingId(String var1);

        public Builder thingTypeName(String var1);

        public Builder thingGroupNames(Collection<String> var1);

        public Builder thingGroupNames(String ... var1);

        public Builder attributes(Map<String, String> var1);

        public Builder shadow(String var1);
    }
}

