/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PolicyDocumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerResponse
extends IotResponse
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
    private final Boolean isAuthenticated;
    private final String principalId;
    private final List<String> policyDocuments;
    private final Integer refreshAfterInSeconds;
    private final Integer disconnectAfterInSeconds;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.isAuthenticated = builder.isAuthenticated;
        this.principalId = builder.principalId;
        this.policyDocuments = builder.policyDocuments;
        this.refreshAfterInSeconds = builder.refreshAfterInSeconds;
        this.disconnectAfterInSeconds = builder.disconnectAfterInSeconds;
    }

    public Boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public String principalId() {
        return this.principalId;
    }

    public List<String> policyDocuments() {
        return this.policyDocuments;
    }

    public Integer refreshAfterInSeconds() {
        return this.refreshAfterInSeconds;
    }

    public Integer disconnectAfterInSeconds() {
        return this.disconnectAfterInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshAfterInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectAfterInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse)((Object)obj);
        return Objects.equals(this.isAuthenticated(), other.isAuthenticated()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.policyDocuments(), other.policyDocuments()) && Objects.equals(this.refreshAfterInSeconds(), other.refreshAfterInSeconds()) && Objects.equals(this.disconnectAfterInSeconds(), other.disconnectAfterInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerResponse").add("IsAuthenticated", (Object)this.isAuthenticated()).add("PrincipalId", (Object)this.principalId()).add("PolicyDocuments", this.policyDocuments()).add("RefreshAfterInSeconds", (Object)this.refreshAfterInSeconds()).add("DisconnectAfterInSeconds", (Object)this.disconnectAfterInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.isAuthenticated()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "policyDocuments": {
                return Optional.ofNullable(clazz.cast(this.policyDocuments()));
            }
            case "refreshAfterInSeconds": {
                return Optional.ofNullable(clazz.cast(this.refreshAfterInSeconds()));
            }
            case "disconnectAfterInSeconds": {
                return Optional.ofNullable(clazz.cast(this.disconnectAfterInSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private Boolean isAuthenticated;
        private String principalId;
        private List<String> policyDocuments = DefaultSdkAutoConstructList.getInstance();
        private Integer refreshAfterInSeconds;
        private Integer disconnectAfterInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            this.isAuthenticated(model.isAuthenticated);
            this.principalId(model.principalId);
            this.policyDocuments(model.policyDocuments);
            this.refreshAfterInSeconds(model.refreshAfterInSeconds);
            this.disconnectAfterInSeconds(model.disconnectAfterInSeconds);
        }

        public final Boolean getIsAuthenticated() {
            return this.isAuthenticated;
        }

        @Override
        public final Builder isAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
            return this;
        }

        public final void setIsAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final Collection<String> getPolicyDocuments() {
            return this.policyDocuments;
        }

        @Override
        public final Builder policyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDocuments(String ... policyDocuments) {
            this.policyDocuments(Arrays.asList(policyDocuments));
            return this;
        }

        public final void setPolicyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
        }

        public final Integer getRefreshAfterInSeconds() {
            return this.refreshAfterInSeconds;
        }

        @Override
        public final Builder refreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
            return this;
        }

        public final void setRefreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
        }

        public final Integer getDisconnectAfterInSeconds() {
            return this.disconnectAfterInSeconds;
        }

        @Override
        public final Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
            return this;
        }

        public final void setDisconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        public Builder isAuthenticated(Boolean var1);

        public Builder principalId(String var1);

        public Builder policyDocuments(Collection<String> var1);

        public Builder policyDocuments(String ... var1);

        public Builder refreshAfterInSeconds(Integer var1);

        public Builder disconnectAfterInSeconds(Integer var1);
    }
}

