/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.TaskStatisticsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, TaskStatistics> {
    private final Integer totalChecks;
    private final Integer inProgressChecks;
    private final Integer waitingForDataCollectionChecks;
    private final Integer compliantChecks;
    private final Integer nonCompliantChecks;
    private final Integer failedChecks;
    private final Integer canceledChecks;

    private TaskStatistics(BuilderImpl builder) {
        this.totalChecks = builder.totalChecks;
        this.inProgressChecks = builder.inProgressChecks;
        this.waitingForDataCollectionChecks = builder.waitingForDataCollectionChecks;
        this.compliantChecks = builder.compliantChecks;
        this.nonCompliantChecks = builder.nonCompliantChecks;
        this.failedChecks = builder.failedChecks;
        this.canceledChecks = builder.canceledChecks;
    }

    public Integer totalChecks() {
        return this.totalChecks;
    }

    public Integer inProgressChecks() {
        return this.inProgressChecks;
    }

    public Integer waitingForDataCollectionChecks() {
        return this.waitingForDataCollectionChecks;
    }

    public Integer compliantChecks() {
        return this.compliantChecks;
    }

    public Integer nonCompliantChecks() {
        return this.nonCompliantChecks;
    }

    public Integer failedChecks() {
        return this.failedChecks;
    }

    public Integer canceledChecks() {
        return this.canceledChecks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgressChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitingForDataCollectionChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.canceledChecks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskStatistics)) {
            return false;
        }
        TaskStatistics other = (TaskStatistics)obj;
        return Objects.equals(this.totalChecks(), other.totalChecks()) && Objects.equals(this.inProgressChecks(), other.inProgressChecks()) && Objects.equals(this.waitingForDataCollectionChecks(), other.waitingForDataCollectionChecks()) && Objects.equals(this.compliantChecks(), other.compliantChecks()) && Objects.equals(this.nonCompliantChecks(), other.nonCompliantChecks()) && Objects.equals(this.failedChecks(), other.failedChecks()) && Objects.equals(this.canceledChecks(), other.canceledChecks());
    }

    public String toString() {
        return ToString.builder((String)"TaskStatistics").add("TotalChecks", (Object)this.totalChecks()).add("InProgressChecks", (Object)this.inProgressChecks()).add("WaitingForDataCollectionChecks", (Object)this.waitingForDataCollectionChecks()).add("CompliantChecks", (Object)this.compliantChecks()).add("NonCompliantChecks", (Object)this.nonCompliantChecks()).add("FailedChecks", (Object)this.failedChecks()).add("CanceledChecks", (Object)this.canceledChecks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalChecks": {
                return Optional.ofNullable(clazz.cast(this.totalChecks()));
            }
            case "inProgressChecks": {
                return Optional.ofNullable(clazz.cast(this.inProgressChecks()));
            }
            case "waitingForDataCollectionChecks": {
                return Optional.ofNullable(clazz.cast(this.waitingForDataCollectionChecks()));
            }
            case "compliantChecks": {
                return Optional.ofNullable(clazz.cast(this.compliantChecks()));
            }
            case "nonCompliantChecks": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantChecks()));
            }
            case "failedChecks": {
                return Optional.ofNullable(clazz.cast(this.failedChecks()));
            }
            case "canceledChecks": {
                return Optional.ofNullable(clazz.cast(this.canceledChecks()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalChecks;
        private Integer inProgressChecks;
        private Integer waitingForDataCollectionChecks;
        private Integer compliantChecks;
        private Integer nonCompliantChecks;
        private Integer failedChecks;
        private Integer canceledChecks;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskStatistics model) {
            this.totalChecks(model.totalChecks);
            this.inProgressChecks(model.inProgressChecks);
            this.waitingForDataCollectionChecks(model.waitingForDataCollectionChecks);
            this.compliantChecks(model.compliantChecks);
            this.nonCompliantChecks(model.nonCompliantChecks);
            this.failedChecks(model.failedChecks);
            this.canceledChecks(model.canceledChecks);
        }

        public final Integer getTotalChecks() {
            return this.totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        public final Integer getInProgressChecks() {
            return this.inProgressChecks;
        }

        @Override
        public final Builder inProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
            return this;
        }

        public final void setInProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
        }

        public final Integer getWaitingForDataCollectionChecks() {
            return this.waitingForDataCollectionChecks;
        }

        @Override
        public final Builder waitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
            return this;
        }

        public final void setWaitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
        }

        public final Integer getCompliantChecks() {
            return this.compliantChecks;
        }

        @Override
        public final Builder compliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
            return this;
        }

        public final void setCompliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
        }

        public final Integer getNonCompliantChecks() {
            return this.nonCompliantChecks;
        }

        @Override
        public final Builder nonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
            return this;
        }

        public final void setNonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
        }

        public final Integer getFailedChecks() {
            return this.failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        public final Integer getCanceledChecks() {
            return this.canceledChecks;
        }

        @Override
        public final Builder canceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
            return this;
        }

        public final void setCanceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
        }

        public TaskStatistics build() {
            return new TaskStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TaskStatistics> {
        public Builder totalChecks(Integer var1);

        public Builder inProgressChecks(Integer var1);

        public Builder waitingForDataCollectionChecks(Integer var1);

        public Builder compliantChecks(Integer var1);

        public Builder nonCompliantChecks(Integer var1);

        public Builder failedChecks(Integer var1);

        public Builder canceledChecks(Integer var1);
    }
}

