/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuditFrequency;
import software.amazon.awssdk.services.iot.model.DayOfWeek;
import software.amazon.awssdk.services.iot.transform.ScheduledAuditMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledAuditMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ScheduledAuditMetadata> {
    private final String scheduledAuditName;
    private final String scheduledAuditArn;
    private final String frequency;
    private final String dayOfMonth;
    private final String dayOfWeek;

    private ScheduledAuditMetadata(BuilderImpl builder) {
        this.scheduledAuditName = builder.scheduledAuditName;
        this.scheduledAuditArn = builder.scheduledAuditArn;
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
    }

    public String scheduledAuditName() {
        return this.scheduledAuditName;
    }

    public String scheduledAuditArn() {
        return this.scheduledAuditArn;
    }

    public AuditFrequency frequency() {
        return AuditFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public String dayOfMonth() {
        return this.dayOfMonth;
    }

    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAuditMetadata)) {
            return false;
        }
        ScheduledAuditMetadata other = (ScheduledAuditMetadata)obj;
        return Objects.equals(this.scheduledAuditName(), other.scheduledAuditName()) && Objects.equals(this.scheduledAuditArn(), other.scheduledAuditArn()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledAuditMetadata").add("ScheduledAuditName", (Object)this.scheduledAuditName()).add("ScheduledAuditArn", (Object)this.scheduledAuditArn()).add("Frequency", (Object)this.frequencyAsString()).add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeekAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduledAuditName": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditName()));
            }
            case "scheduledAuditArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditArn()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "dayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "dayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduledAuditMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduledAuditName;
        private String scheduledAuditArn;
        private String frequency;
        private String dayOfMonth;
        private String dayOfWeek;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAuditMetadata model) {
            this.scheduledAuditName(model.scheduledAuditName);
            this.scheduledAuditArn(model.scheduledAuditArn);
            this.frequency(model.frequency);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
        }

        public final String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        public final String getScheduledAuditArn() {
            return this.scheduledAuditArn;
        }

        @Override
        public final Builder scheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        public final void setScheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public ScheduledAuditMetadata build() {
            return new ScheduledAuditMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledAuditMetadata> {
        public Builder scheduledAuditName(String var1);

        public Builder scheduledAuditArn(String var1);

        public Builder frequency(String var1);

        public Builder frequency(AuditFrequency var1);

        public Builder dayOfMonth(String var1);

        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);
    }
}

