/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PolicyVersionIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVersionIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyVersionIdentifier> {
    private final String policyName;
    private final String policyVersionId;

    private PolicyVersionIdentifier(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyVersionId = builder.policyVersionId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyVersionId() {
        return this.policyVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersionIdentifier)) {
            return false;
        }
        PolicyVersionIdentifier other = (PolicyVersionIdentifier)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyVersionId(), other.policyVersionId());
    }

    public String toString() {
        return ToString.builder((String)"PolicyVersionIdentifier").add("PolicyName", (Object)this.policyName()).add("PolicyVersionId", (Object)this.policyVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyVersionIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersionIdentifier model) {
            this.policyName(model.policyName);
            this.policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        public PolicyVersionIdentifier build() {
            return new PolicyVersionIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyVersionIdentifier> {
        public Builder policyName(String var1);

        public Builder policyVersionId(String var1);
    }
}

