/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.LogTargetType;
import software.amazon.awssdk.services.iot.transform.LogTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogTarget
implements StructuredPojo,
ToCopyableBuilder<Builder, LogTarget> {
    private final String targetType;
    private final String targetName;

    private LogTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetName = builder.targetName;
    }

    public LogTargetType targetType() {
        return LogTargetType.fromValue(this.targetType);
    }

    public String targetTypeAsString() {
        return this.targetType;
    }

    public String targetName() {
        return this.targetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogTarget)) {
            return false;
        }
        LogTarget other = (LogTarget)obj;
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetName(), other.targetName());
    }

    public String toString() {
        return ToString.builder((String)"LogTarget").add("TargetType", (Object)this.targetTypeAsString()).add("TargetName", (Object)this.targetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetType;
        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogTarget model) {
            this.targetType(model.targetType);
            this.targetName(model.targetName);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(LogTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public LogTarget build() {
            return new LogTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogTarget> {
        public Builder targetType(String var1);

        public Builder targetType(LogTargetType var1);

        public Builder targetName(String var1);
    }
}

