/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IndexNamesListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndicesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListIndicesResponse> {
    private final List<String> indexNames;
    private final String nextToken;

    private ListIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexNames = builder.indexNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> indexNames() {
        return this.indexNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicesResponse)) {
            return false;
        }
        ListIndicesResponse other = (ListIndicesResponse)((Object)obj);
        return Objects.equals(this.indexNames(), other.indexNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIndicesResponse").add("IndexNames", this.indexNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexNames": {
                return Optional.ofNullable(clazz.cast(this.indexNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> indexNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicesResponse model) {
            super(model);
            this.indexNames(model.indexNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getIndexNames() {
            return this.indexNames;
        }

        @Override
        public final Builder indexNames(Collection<String> indexNames) {
            this.indexNames = IndexNamesListCopier.copy(indexNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexNames(String ... indexNames) {
            this.indexNames(Arrays.asList(indexNames));
            return this;
        }

        public final void setIndexNames(Collection<String> indexNames) {
            this.indexNames = IndexNamesListCopier.copy(indexNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIndicesResponse build() {
            return new ListIndicesResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListIndicesResponse> {
        public Builder indexNames(Collection<String> var1);

        public Builder indexNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

