/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Certificate;
import software.amazon.awssdk.services.iot.model.CertificatesCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesByCaResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCertificatesByCaResponse> {
    private final List<Certificate> certificates;
    private final String nextMarker;

    private ListCertificatesByCaResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<Certificate> certificates() {
        return this.certificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCaResponse)) {
            return false;
        }
        ListCertificatesByCaResponse other = (ListCertificatesByCaResponse)((Object)obj);
        return Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificatesByCaResponse").add("Certificates", this.certificates()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCaResponse model) {
            super(model);
            this.certificates(model.certificates);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return this.certificates != null ? (Collection)this.certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (Certificate)((Certificate.Builder)Certificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCertificatesByCaResponse build() {
            return new ListCertificatesByCaResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListCertificatesByCaResponse> {
        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder certificates(Consumer<Certificate.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

