/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadata;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadataListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditTasksResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuditTasksResponse> {
    private final List<AuditTaskMetadata> tasks;
    private final String nextToken;

    private ListAuditTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public List<AuditTaskMetadata> tasks() {
        return this.tasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditTasksResponse)) {
            return false;
        }
        ListAuditTasksResponse other = (ListAuditTasksResponse)((Object)obj);
        return Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAuditTasksResponse").add("Tasks", this.tasks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuditTaskMetadata> tasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<AuditTaskMetadata.Builder> getTasks() {
            return this.tasks != null ? (Collection)this.tasks.stream().map(AuditTaskMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<AuditTaskMetadata> tasks) {
            this.tasks = AuditTaskMetadataListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(AuditTaskMetadata ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<AuditTaskMetadata.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (AuditTaskMetadata)((AuditTaskMetadata.Builder)AuditTaskMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<AuditTaskMetadata.BuilderImpl> tasks) {
            this.tasks = AuditTaskMetadataListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAuditTasksResponse build() {
            return new ListAuditTasksResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListAuditTasksResponse> {
        public Builder tasks(Collection<AuditTaskMetadata> var1);

        public Builder tasks(AuditTaskMetadata ... var1);

        public Builder tasks(Consumer<AuditTaskMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

