/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.JobExecutionSummary;
import software.amazon.awssdk.services.iot.transform.JobExecutionSummaryForJobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummaryForJob
implements StructuredPojo,
ToCopyableBuilder<Builder, JobExecutionSummaryForJob> {
    private final String thingArn;
    private final JobExecutionSummary jobExecutionSummary;

    private JobExecutionSummaryForJob(BuilderImpl builder) {
        this.thingArn = builder.thingArn;
        this.jobExecutionSummary = builder.jobExecutionSummary;
    }

    public String thingArn() {
        return this.thingArn;
    }

    public JobExecutionSummary jobExecutionSummary() {
        return this.jobExecutionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummaryForJob)) {
            return false;
        }
        JobExecutionSummaryForJob other = (JobExecutionSummaryForJob)obj;
        return Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.jobExecutionSummary(), other.jobExecutionSummary());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSummaryForJob").add("ThingArn", (Object)this.thingArn()).add("JobExecutionSummary", (Object)this.jobExecutionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "jobExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionSummaryForJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingArn;
        private JobExecutionSummary jobExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummaryForJob model) {
            this.thingArn(model.thingArn);
            this.jobExecutionSummary(model.jobExecutionSummary);
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final JobExecutionSummary.Builder getJobExecutionSummary() {
            return this.jobExecutionSummary != null ? this.jobExecutionSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary;
            return this;
        }

        public final void setJobExecutionSummary(JobExecutionSummary.BuilderImpl jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary != null ? jobExecutionSummary.build() : null;
        }

        public JobExecutionSummaryForJob build() {
            return new JobExecutionSummaryForJob(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobExecutionSummaryForJob> {
        public Builder thingArn(String var1);

        public Builder jobExecutionSummary(JobExecutionSummary var1);

        default public Builder jobExecutionSummary(Consumer<JobExecutionSummary.Builder> jobExecutionSummary) {
            return this.jobExecutionSummary((JobExecutionSummary)((JobExecutionSummary.Builder)JobExecutionSummary.builder().applyMutation(jobExecutionSummary)).build());
        }
    }
}

