/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.JobExecutionStatus;
import software.amazon.awssdk.services.iot.transform.JobExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, JobExecutionSummary> {
    private final String status;
    private final Instant queuedAt;
    private final Instant startedAt;
    private final Instant lastUpdatedAt;
    private final Long executionNumber;

    private JobExecutionSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
    }

    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant queuedAt() {
        return this.queuedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Long executionNumber() {
        return this.executionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.executionNumber(), other.executionNumber());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSummary").add("Status", (Object)this.statusAsString()).add("QueuedAt", (Object)this.queuedAt()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ExecutionNumber", (Object)this.executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "queuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "executionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant queuedAt;
        private Instant startedAt;
        private Instant lastUpdatedAt;
        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            this.status(model.status);
            this.queuedAt(model.queuedAt);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.executionNumber(model.executionNumber);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getQueuedAt() {
            return this.queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobExecutionSummary> {
        public Builder status(String var1);

        public Builder status(JobExecutionStatus var1);

        public Builder queuedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder executionNumber(Long var1);
    }
}

