/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.DetailsMapCopier;
import software.amazon.awssdk.services.iot.transform.JobExecutionStatusDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionStatusDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, JobExecutionStatusDetails> {
    private final Map<String, String> detailsMap;

    private JobExecutionStatusDetails(BuilderImpl builder) {
        this.detailsMap = builder.detailsMap;
    }

    public Map<String, String> detailsMap() {
        return this.detailsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detailsMap());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionStatusDetails)) {
            return false;
        }
        JobExecutionStatusDetails other = (JobExecutionStatusDetails)obj;
        return Objects.equals(this.detailsMap(), other.detailsMap());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionStatusDetails").add("DetailsMap", this.detailsMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detailsMap": {
                return Optional.ofNullable(clazz.cast(this.detailsMap()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionStatusDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> detailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionStatusDetails model) {
            this.detailsMap(model.detailsMap);
        }

        public final Map<String, String> getDetailsMap() {
            return this.detailsMap;
        }

        @Override
        public final Builder detailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
            return this;
        }

        public final void setDetailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
        }

        public JobExecutionStatusDetails build() {
            return new JobExecutionStatusDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobExecutionStatusDetails> {
        public Builder detailsMap(Map<String, String> var1);
    }
}

