/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetV2LoggingOptionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetV2LoggingOptionsResponse> {
    private final String roleArn;
    private final String defaultLogLevel;
    private final Boolean disableAllLogs;

    private GetV2LoggingOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.defaultLogLevel = builder.defaultLogLevel;
        this.disableAllLogs = builder.disableAllLogs;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public LogLevel defaultLogLevel() {
        return LogLevel.fromValue(this.defaultLogLevel);
    }

    public String defaultLogLevelAsString() {
        return this.defaultLogLevel;
    }

    public Boolean disableAllLogs() {
        return this.disableAllLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAllLogs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetV2LoggingOptionsResponse)) {
            return false;
        }
        GetV2LoggingOptionsResponse other = (GetV2LoggingOptionsResponse)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.defaultLogLevelAsString(), other.defaultLogLevelAsString()) && Objects.equals(this.disableAllLogs(), other.disableAllLogs());
    }

    public String toString() {
        return ToString.builder((String)"GetV2LoggingOptionsResponse").add("RoleArn", (Object)this.roleArn()).add("DefaultLogLevel", (Object)this.defaultLogLevelAsString()).add("DisableAllLogs", (Object)this.disableAllLogs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "defaultLogLevel": {
                return Optional.ofNullable(clazz.cast(this.defaultLogLevelAsString()));
            }
            case "disableAllLogs": {
                return Optional.ofNullable(clazz.cast(this.disableAllLogs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String roleArn;
        private String defaultLogLevel;
        private Boolean disableAllLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetV2LoggingOptionsResponse model) {
            super(model);
            this.roleArn(model.roleArn);
            this.defaultLogLevel(model.defaultLogLevel);
            this.disableAllLogs(model.disableAllLogs);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDefaultLogLevel() {
            return this.defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel.toString());
            return this;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        public final Boolean getDisableAllLogs() {
            return this.disableAllLogs;
        }

        @Override
        public final Builder disableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
            return this;
        }

        public final void setDisableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
        }

        @Override
        public GetV2LoggingOptionsResponse build() {
            return new GetV2LoggingOptionsResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, GetV2LoggingOptionsResponse> {
        public Builder roleArn(String var1);

        public Builder defaultLogLevel(String var1);

        public Builder defaultLogLevel(LogLevel var1);

        public Builder disableAllLogs(Boolean var1);
    }
}

